<?php

namespace Mtc\Coupons\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Coupons\Facades\Coupon;
use Mtc\Coupons\Http\Requests\ApplicableCouponRequest;

/**
 * Class CouponController
 *
 * @package Mtc\Coupons\Http\Controllers\Admin
 */
class CouponController extends Controller
{
    /**
     * Add coupon to basket discounts
     *
     * @param ApplicableCouponRequest $request
     * @param BasketRepositoryInterface $basket
     * @return mixed
     */
    public function store(ApplicableCouponRequest $request, BasketRepositoryInterface $basket)
    {
        $code = Coupon::getFromCode($request->input('code'));
        $basket->addDiscount($code->id, 'coupon');
        return response()->json([
            'message' => __('coupons::coupons.applied_to_basket'),
            'basket' => App::make(config('basket.ajax_response_class'))
        ]);
    }
}
