<?php

namespace Mtc\Coupons\Contracts;

use Illuminate\Database\Eloquent\Model;

/**
 * Interface TypeContract
 * @package Mtc\Coupons\Contracts
 */
interface TypeContract
{
    /**
     * Apply discounted amounted
     *
     * @param Model $coupon
     * @param $basket
     * @param $set_discounted_amount
     * @return mixed
     */
    public function apply(Model $coupon, $basket, bool $set_discounted_amount);

    /**
     * Get Discounted values for item line
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    public function getDiscountedValues($coupon, $item);
}
