<?php

namespace Mtc\Coupons\Validators;

use Illuminate\Database\Eloquent\Model;
use Mtc\Basket\Contracts\BasketContract;
use Mtc\Coupons\Coupon;

/**
 * Class DiscountableItem
 * @package Mtc\Coupons\Validators
 */
class DiscountableItem
{
    /**
     * @param Coupon $coupon
     * @param $item
     * @return bool
     */
    public function validate(Coupon $coupon, $item)
    {
        if ($coupon->sale_restriction === Coupon::ALL_ITEMS) {
            return true;
        }

        if ($coupon->sale_restriction === Coupon::NON_SALE_ITEMS && !$item->purchasable->hasDiscountedPrice()) {
            return true;
        }

        if ($coupon->sale_restriction === Coupon::ONLY_SALE_ITEMS && $item->purchasable->hasDiscountedPrice()) {
            return true;
        }

        return false;
    }
}
