<?php

namespace Mtc\Coupons\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Coupons\Contracts\CouponRepositoryInterface;

/**
 * Class SetBasketDiscount
 * @package Mtc\MultiBuy\Listeners
 */
class ValidateCheckoutCoupon
{
    /**
     * Handle the event.
     *
     * @param $event
     */
    public function handle($basket_model)
    {
        $basket_model->discounts()
            ->where('discount_type', 'coupon')
            ->get()
            ->reject(function ($discount_to_check) use ($basket_model) {
                /** @var CouponRepositoryInterface $coupon_repository */
                $coupon_repository = App::make(CouponRepositoryInterface::class);
                $coupon_repository->setModel($discount_to_check->discount);
                return $coupon_repository->isAvailable($basket_model);
            })
            ->each(function ($discount_to_remove) {
                $discount_to_remove->delete();
            });
    }
}
