<?php

namespace Mtc\Coupons\Filters;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;
use Mtc\Orders\Status;

/**
 * Class FilterByStatus
 * 
 * @package Mtc\Orders\Filters
 */
class FilterByStatus implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'status';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'select',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Status',
            'default_option_label' => 'All',
            'values' => [
                'usable' => 'Active',
                'upcoming' => 'Upcoming',
                'expired' => 'Expired',
            ],
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where(function ($query) use ($request) {
            switch ($request->input(self::INPUT_FIELD_NAME)) {
                case 'usable':
                    return $query->active();
                    break;
                case 'expired':
                    return $query->where('valid_to', '<=', Carbon::now())
                        ->orWhere(function ($sub_query) {
                            return $sub_query->where('redemptions', 0)
                                ->whereNull('valid_to');
                        });
                    break;
                case 'upcoming':
                    return $query->where('valid_from', '>=', Carbon::now());
                    break;
            }
        });
    }
}
