<?php

namespace Mtc\Core\Seeds;

use Illuminate\Support\Facades\Cache;
use Mtc\Core\Admin\Setting;
use Illuminate\Database\Seeder;

/**
 * Class SettingSeeder
 */
class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::Insert($this->getData());
    }

    /**
     * seed data
     *
     * @return array
     */
    protected function getData()
    {
        $setup_config = Cache::get('install-config');
        return [
            [
                'key' => 'SITE_CREATION_DATE',
                'type' => 'string',
                'value' => \Carbon\Carbon::now()->format('Y-m-d'),
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'DEV_EMAIL',
                'type' => 'string',
                'value' => $setup_config['dev_email'] ?? '',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'FROM_EMAIL',
                'type' => 'string',
                'value' => $setup_config['dev_email'] ?? '',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'CONTACT_EMAIL',
                'type' => 'string',
                'value' => $setup_config['dev_email'] ?? '',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'TELEPHONE_NUMBER',
                'type' => 'string',
                'value' => '',
                'module' => null,
                'description' => 'Telephone number'
            ],
            [
                'key' => 'PHP_LIB',
                'type' => 'string',
                'value' => '/usr/local/bin/php',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'IMAGE_IDENTIFY',
                'type' => 'string',
                'value' => '/usr/local/bin/identify',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'IMAGE_MOGRIFY',
                'type' => 'string',
                'value' => '/usr/local/bin/mogrify',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'IMAGE_CONVERT',
                'type' => 'string',
                'value' => '/usr/local/bin/convert',
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'HOMEPAGE',
                'type' => 'int',
                'value' => 1,
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'DEBUG_BAR',
                'type' => 'bool',
                'value' => 0,
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'MTCADMIN_USERID',
                'type' => 'int',
                'value' => 1,
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'PAF_ENABLED',
                'type' => 'bool',
                'value' => 0,
                'module' => null,
                'description' => 'Postcode Address Finder (Paid Feature)'
            ],
            [
                'key' => 'STATS_ENABLED',
                'type' => 'bool',
                'value' => 1,
                'module' => null,
                'description' => null
            ],
            [
                'key' => 'MTC_ADMIN_GOOGLE_ANALYTICS_USERAGENT',
                'type' => 'string',
                'value' => 'UA-71263318-1',
                'module' => null,
                'description' => 'The mtc. global admin area Google Analytics Useragent. '
                    . 'Should be the same for all mtc. admin areas. "What gets measured, gets managed."'
            ],
            [
                'key' => 'FILE_MANAGER',
                'type' => 'bool',
                'value' => 0,
                'module' => null,
                'description' => 'Allow clients to manage MoxieManager files and folders.'
            ],
            [
                'key' => 'BREADCRUMBS',
                'type' => 'bool',
                'value' => 0,
                'module' => null,
                'description' => 'Breadcrumbs functions are enabled by setting this true'
            ],
            [
                'key' => 'BREADCRUMBS_LINK_LAST_CRUMB',
                'type' => 'bool',
                'value' => 1,
                'module' => null,
                'description' => 'Whether there should be a link on the last crumb of breadcrumbs'
            ],
            [
                'key' => 'IMAGE_RESIZE_MEMORY_LIMIT',
                'type' => 'string',
                'value' => '512M',
                'module' => null,
                'description' => 'Memory limit during image resize.'
            ],
            [
                'key' => 'ENABLE_CURRENCIES',
                'type' => 'bool',
                'value' => 0,
                'module' => null,
                'description' => 'Enable / Disable the ability to change the currency on the ecommerce. '
                    . 'Individual currencies will still need enabled seperately.'
            ],
            [
                'key' => 'GOOGLE_MAPS_JS_API_KEY',
                'type' => 'string',
                'value' => 'AIzaSyDsXjQCYz4s2ldq4rh6AA5C_Iv66xDvqkQ',
                'module' => null,
                'description' => 'Google Maps JS API Key. If website uses maps api heavily make sure this is website'
                    . ' specific or even possibly clients very own.'
            ],
            [
                'key' => 'IMAGE_OPTIMISE_LOSSLESS',
                'type' => 'bool',
                'value' => 1,
                'module' => null,
                'description' => 'Enables lossless image optimization for all image uploads. If enabled, will use: '
                    . 'jpegtran, jpegoptim, pngquant, optipng, pngcrush & advpng command line tools.'
            ],
            [
                'key' => 'IMAGE_FAKER',
                'type' => 'bool',
                'value' => 1,
                'module' => null,
                'description' => 'Enables image faker.'
            ],
            [
                'key' => 'PAGINATION_PAGES_TO_DISPLAY',
                'type' => 'int',
                'value' => 5,
                'module' => null,
                'description' => 'Number of pagination links to display on either side of current page'
            ],
            [
                'key' => 'RECAPTCHA_SECRET',
                'type' => 'string',
                'value' => '',
                'module' => 'CORE',
                'description' => 'Recaptcha secret'
            ],
            [
                'key' => 'RECAPTCHA_SITE_KEY',
                'type' => 'string',
                'value' => '',
                'module' => 'CORE',
                'description' => 'Recaptcha site key'
            ],
        ];
    }
}
