# mtcmedia/core

## Pull Requests
Please review the [pull request process](http://wiki.mtcmedia.co.uk/index.php?title=Pull_Request_Process) on our internal wiki.

## Installation

Please refer to the [5 minute install guide on the mtc. wiki](http://wiki.mtcmedia.co.uk/index.php?title=Core_-_5_Minute_Install) on instructions on how to install the core and it's modules.

## Setting up a new site
1. Install the core on the staging account
2. Set up Site Features/Settings in ``/admin/settings/``
3. Set up the live MySQL settings in the file ``public_html/sites/{your site}/settings/settings.live.php``
4. rsync the site up to live:
   
   **dry run**: ``rsync -azmcOn --progress --exclude vendor ~/public_html/ {live user}@{live domain}:~/public_html/``

   **copy files**: ``rsync -azmcO --progress --exclude vendor ~/public_html/ {live user}@{live domain}:~/public_html/``
5. Go to CVCS and click Install in the "Staging" row
6. Make sure the ignore file contains the following line: ``/core/includes/environment.php``
7. Install the VCS
8. Don't forget to create live database and to import the database from 
staging
9. Edit ``public_html/core/includes/environment.php`` on the live account and set the environement to live:
```
#!php
<?php

define('ENVIRONMENT', 'live');
```
