<?php

namespace Mtc\Core\Seeds;

use Illuminate\Database\Seeder;

class AdminMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (\Mtc\Core\Admin\Menu::query()->count() > 0) {
            return;
        }

        collect(self::getData())
            ->each(function ($menu_entry) {
                $children = $menu_entry['children'] ?? [];
                unset($menu_entry['children']);
                $menu = \Mtc\Core\Admin\Menu::query()->create($menu_entry);

                foreach ($children as $sub_menu) {
                    $roles = $sub_menu['roles'] ?? [];
                    unset($sub_menu['roles']);
                    $child = $menu->children()->create($sub_menu);
                    \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
                }
            });
    }

    /**
     * Fetch the menu entries to seed
     *
     * @return array
     */
    protected static function getData()
    {
        return [
            [
                'title' => 'MTC Only',
                'path' => '',
                'activePath' => '',
                'constant' => '',
                'icon' => 'fas fa-cogs',
                'children' => [
                    [
                        'title' => 'Admin Menu',
                        'path' => '/admin/menu/',
                        'activePath' => 'admin/menu',
                        'constant' => '',
                    ],
                    [
                        'title' => 'SEO Admin',
                        'path' => '/admin/seo/',
                        'activePath' => 'admin/seo',
                        'constant' => '',
                    ],
                    [
                        'title' => 'Populate',
                        'path' => '/admin/populate',
                        'activePath' => 'admin/populate',
                        'constant' => '',
                    ],
                    [
                        'title' => 'Core Emails',
                        'path' => '/admin/emails',
                        'activePath' => 'admin/emails',
                        'constant' => '',
                    ],
                    [
                        'title' => 'Component Manager',
                        'path' => '/admin/components/',
                        'activePath' => 'admin/components',
                        'constant' => '',
                    ],
                ]
            ],
            [
                'title' => 'Admin Users',
                'path' => '',
                'activePath' => '',
                'constant' => '',
                'icon' => 'fas fa-users',
                'order' => 1,
                'children' => [
                    [
                        'title' => 'Admin Users',
                        'path' => '/admin/users',
                        'activePath' => '/admin/users',
                        'constant' => '',
                        'roles' => [
                            'Administrator'
                        ],
                    ],
                    [
                        'title' => 'User Roles',
                        'path' => '/admin/roles',
                        'activePath' => '/admin/roles',
                        'constant' => '',
                    ],
                ]
            ],
            [
                'title' => 'File Manager',
                'path' => '',
                'activePath' => '',
                'constant' => 'FILE_MANAGER',
                'icon' => 'far fa-folder-open',
                'order' => 9,
                'children' => [
                    [
                        'title' => 'File Manager',
                        'path' => '/admin/file-manager/',
                        'activePath' => '/admin/file-manager',
                        'constant' => 'FILE_MANAGER',
                        'roles' => [
                            'Administrator'
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Reports',
                'path' => '',
                'activePath' => '',
                'constant' => 'STATS_ENABLED',
                'icon' => 'fa fa-chart-bar',
                'order' => 10,
                'children' => [
                    [
                        'title' => 'Website Stats',
                        'path' => '/admin/stats',
                        'activePath' => '/admin/stats',
                        'constant' => 'STATS_ENABLED',
                        'roles' => [
                            'Administrator'
                        ],
                    ],
                ]
            ],
            [
                'title' => 'Support',
                'path' => '',
                'activePath' => '',
                'constant' => '',
                'icon' => 'far fa-question-circle',
                'order' => 99,
                'children' => [
                    [
                        'title' => 'Submit a ticket',
                        'path' => 'https://projects.mtcmedia.co.uk',
                        'activePath' => '',
                        'new_window' => 1,
                        'roles' => [
                            'Administrator'
                        ],
                    ],
                ]
            ],
        ];
    }
}
