<?php

namespace Mtc\Core\Media;

use Illuminate\Support\Facades\App;

/**
 * Class MediaLoader
 *
 * Add ability to load media paths on application
 *
 * @package Mtc\Core\Media
 */
class MediaLoader
{
    /**
     * Add a path to image sizes
     *
     * @param string $type
     * @param array $image_folders
     */
    public function addFolders($type, $image_folders)
    {
        $all_folders = $this->getFolders();
        $all_folders[$type] = $image_folders;
        $app = app();
        $app->image_folders = $all_folders;
    }


    /**
     * Add a path to image sizes
     *
     * @param string $path
     */
    public function addPath($path)
    {
        //Check if file exists
        if (!file_exists($path)) {
            return;
        }

        $image_folders = $this->getFolders();
        require_once $path;
        $app = app();
        $app['image_folders'] = $image_folders;
    }

    /**
     * Get the registered image sizes.
     * Accepts parameter to find specific image size group
     *
     * @param string|bool $path
     * @return array
     */
    public function getFolders($path = false)
    {
        $folders = App::make('image_folders');

        if ($path) {
            return $folders[$path] ?? [];
        }

        return $folders;
    }
}
