<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Core\Admin\Seo\Defaults;
use DB;

/**
 * Manages the installation of modules and plugins within the Core admin.
 */
class SeoDefaultsController extends Controller
{
    /**
     * Displays the Default settings
     *
     * @return mixed
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage SEO Defaults';

        $defaults = Defaults::all();

        return template('admin/seo/defaults.twig', [
            'page_meta' => $this->page_meta,
            'defaults' => $defaults,
        ]);
    }


    /**
     * Updates the Default settings
     *
     * @param Request $request
     * @param $default_id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $default_id)
    {
        Defaults::where('id', $default_id)
            ->update([
                'title' => $request->input('title'),
                'description' => $request->input('description')
            ]);

        session()->flash('success', 'Your default has now been updated!');
        return redirect()->back();
    }

    /**
     * Displays the edit page
     *
     * @param $default_id
     * @return mixed
     */
    public function edit($default_id)
    {
        $this->page_meta['title'] = 'Manage SEO Defaults';

        $default_id = Defaults::findOrFail($default_id);

        return template('admin/seo/edit_defaults.twig', [
            'page_meta' => $this->page_meta,
            'default' => $default_id,
        ]);
    }
}
