<?php

namespace Mtc\Core\Http\Controllers\Admin\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Mtc\Core\Http\Controllers\Controller;

/**
 * Class OrderController
 *
 * @package Mtc\Core\Http\Controllers\Admin\Api
 */
class OrderController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function order(Request $request)
    {
        $request->validate([
            'table' => 'required',
            'field' => 'required',
            'rorder' => 'required',
        ]);

        $table_name = preg_replace('/[^a-z0-9_]/i', '', $request->input('table'));
        $order_column = preg_replace('/[^a-z0-9_]/i', '', $request->input('field'));

        if (!empty($request->input('rorder')) && !empty($table_name) && !empty($order_column)) {
            foreach ($request->input('rorder') as $order => $record) {
                DB::table($table_name)
                    ->where('id', $record)
                    ->update([$order_column => $order]);
            }
        }

        return response()->json(['message' => 'success']);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function paginatedOrder(Request $request)
    {
        $request->validate([
            'table' => 'required',
            'field' => 'required',
            'page_num' => 'required',
            'rows_per_page' => 'required',
            'item_position' => 'required',
            'item_id' => 'required',
        ]);

        $table_name = preg_replace('/[^a-z0-9_]/i', '', $request->input('table'));
        $order_column = preg_replace('/[^a-z0-9_]/i', '', $request->input('field'));

        $main_query = DB::table($table_name);

        //ensure categories don't pull in sub cats when re ordering stuff
        if ($table_name == 'categories') {
            $result = DB::table($table_name)
                ->select('sub_id')
                ->where('id', $request->input('item_id'))
                ->first();

            if ($result) {
                $main_query->where('sub_id', $result->sub_id);
            }
        }

        //get a list of all row ids from the table in the current order
        $results = $main_query->orderBy($order_column)->get();

        if ($results) {
            $order = $results->pluck('id')->toArray();

            //remove the element representing the item from the array
            if (($key = array_search($request->input('item_id'), $order)) !== false) {
                unset($order[$key]);
            }

            //work out where the item should go in the array, ie the nth position
            $new_position = (($request->input('page_num') - 1) * $request->input('rows_per_page'))
                + $request->input('item_position');

            //split the order array up into a before and an after chunk
            $chunk_before_new_position = array_slice($order, 0, $new_position);
            $chunk_after_new_position = array_slice($order, $new_position);

            //stitch them back together with the moved item at the new position
            $order = array_merge($chunk_before_new_position, [$request->input('item_id')], $chunk_after_new_position);

            //update the table with the new order
            foreach ($order as $position => $id) {
                DB::table($table_name)
                    ->where('id', $id)
                    ->update([$order_column => $position]);
            }
        }

        return response()->json(['message' => 'success']);
    }
}
