<?php

namespace Mtc\Core\Services;

use Illuminate\Http\Request;
use GeoIp2\Database\Reader;
use Illuminate\Support\Facades\Session;
use Mtc\Core\Models\Country;

/**
 * Class LocationService
 *
 * Service that looks at users location
 *
 * @package Mtc\Core
 */
class LocationService
{
    /**
     * @var Request
     */
    private $request;

    /**
     * @var Reader
     */
    private $reader;

    /**
     * LocationService constructor.
     *
     * @param Request $request
     */
    public function __construct(Request $request)
    {
        $this->request = $request;

        if (is_file('/usr/local/lib/php/GeoIP/GeoLite2-Country.mmdb')) {
            $this->reader = new Reader('/usr/local/lib/php/GeoIP/GeoLite2-Country.mmdb');
        }
    }

    /**
     * Detect Country
     *
     * @return array Details of country detected
     */
    public function detectCountry()
    {
        $cookie = $this->request->cookie();
        $session = Session::all() ?: $_SESSION;
        // Initialise empty so we always return an array
        $location = [];

        if (!empty($session['location'])) {
            return $session['location'];
        }

        // No location detected
        if ($this->reader && empty($cookie['detected_country'])) {
            if (!empty($this->request->server('REMOTE_ADDR'))) {
                $country = $this->reader->country($this->request->server('REMOTE_ADDR'));
            }

            // If we have a country code
            if (!empty($country->country->isoCode)) {
                $cookie['detected_country'] = $country->country->isoCode;
                setcookie('detected_country', $country->country->isoCode);
            }
        }

        if (!empty($cookie['detected_country'])) {
            $location = Country::query()
                ->where('code', $cookie['detected_country'])
                ->where('status', 1)
                ->firstOrNew([])
                ->toArray();

            // Saving both versions to  ensure all paths are able to handle this
            $_SESSION['location'] = $location;
            $_SESSION['detected_country'] = $cookie['detected_country'];
            Session::put('location', $location);
            Session::put('detected_country', $cookie['detected_country']);
        }
        return $location;
    }
}
