<?php

namespace Mtc\Core\Seo;

use Mtc\Shop\Category;

/**
 * Seo categories class
 *
 * @author: Lukas Giegerich | mtc.
 * @version 2014-01-20
 * @deprecated
 */
class SeoCategories
{
    /**
     * gets array of seo data for all categories from db
     *
     * @param int $id
     * @return array
     */
    public function getCategory($id)
    {
        $category = Category::query()
            ->select([
                'id',
                'name',
                'seo_title as title',
                'seo_description as description'
            ])
            ->find($id);

        if ($category) {
            return $category->toArray();
        }

        return [
            'id' => '',
            'name' => '',
            'title' => '',
            'description' => '',
        ];
    }

    /**
     * Gets categories from the database
     *
     * @return array
     * @author Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
     *
     */
    public function getSeoCategories()
    {
        return Category::query()
            ->where('sub_id', 0)
            ->where('deleted', 0)
            ->orderBy('name')
            ->get()
            ->each(function ($category) {
                $category->sub_categories = $this->getSubCategories($category->id);
            })
            ->toArray();
    }

    /**
     * updates category seo data in db
     *
     * @param int $id
     * @param string $title
     * @param string $description
     */
    public function updateCategory($id, $title, $description)
    {

        Category::query()
            ->where('id', $id)
            ->update([
                'seo_title' => $title,
                'seo_description' => $description
            ]);
    }

    /**
     * sets seo data for given category to empty string
     * @param int $id
     */
    public function deleteCategory($id)
    {
        $this->updateCategory($id, '', '');
    }

    /**
     * Gets sub categories from the database
     *
     * @param int $parent_id
     * @param string $indent
     * @return array
     *
     */
    public function getSubCategories($parent_id, $indent = '')
    {
        return Category::query()
            ->where('sub_id', $parent_id)
            ->where('deleted', 0)
            ->orderBy('name')
            ->get()
            ->each(function ($category) use ($indent) {
                $new_indent = $indent . '- ';
                $category->name = $new_indent . $category->name;
                $category->sub_categories = $this->getSubCategories($category->id, $new_indent);
            })
            ->toArray();
    }

    /**
     * sets seo data for given category to empty string
     *
     * @param array $categories
     * @return string
     *
     * @author Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
     */
    public function seoCategoryHelperPrintCategories($categories)
    {
        $html = '';
        ob_start();
        foreach ($categories as $category) {
            ?>

            <tr>
                <td>
                    <a href="<?= clean_page(browse_url($category['id'])) ?>" target="_blank">
                        <i class="fa fa-eye"></i>
                    </a>
                </td>
                <td><?= clean_page($category['name']) ?></td>
                <td><?= clean_page($category['seo_title']) ?></td>
                <td><?= clean_page($category['seo_description']) ?></td>
                <td>
                    <a href="?edit=<?= clean_page($category['id']) ?>">
                        <i class="fa fa-pencil"></i>
                    </a>
                    <a href="?delete=<?= clean_page($category['id']) ?>" class="alert error"
                        title="Are you sure you want to delete this seo entry?">
                        <i class="fa fa-times-circle"></i>
                    </a>
                </td>
            </tr>


            <?php
            if (!empty($category['sub_categories'])) {
                echo $this->seoCategoryHelperPrintCategories($category['sub_categories']);
            }
        }
        $html = ob_get_clean();
        return $html;
    }
}
