<?php

namespace Mtc\Core\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Shop\Category;

/**
 * Class SeoCategoryController
 *
 * @package Mtc\Core\Http\Controllers\Admin
 */
class SeoCategoryController extends Controller
{
    /**
     * Displays Seo Page list
     *
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage SEO Categories';

        return template('admin/seo/categories/index.twig', [
            'page_meta' => $this->page_meta,
            'categories' => Category::query()->latest('id')->get(),
        ]);
    }

    /**
     * Render view for editing a page
     *
     * @param Category $category
     * @return string
     */
    public function edit(Category $category)
    {
        $this->page_meta['title'] = 'Edit Seo Category';
        return template('admin/seo/categories/edit.twig', [
            'page_meta' => $this->page_meta,
            'category' => $category,
        ]);
    }

    /**
     * Update a seo page
     *
     * @param Request $request
     * @param Category $category
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, Category $category)
    {
        $validated = $this->validate($request, [
            'seo_title' => 'required',
            'seo_description' => 'present',
        ]);

        $category->fill($validated)->save();
        session()->flash('success', 'Category entry Updated');
        return redirect(route('seo.categories.index'));
    }
}
