@extends('foundation::layouts.admin')

@section('title', 'Config Explorer')

@section('content')
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Config Explorer</li>
    </ul>

    <h1>
        Config Explorer
    </h1>

    <p>
        This section explores configs on system.
        The configs show <strong>default</strong> values. If config is
        overwritten on project level this will <strong>not</strong> update here.
        This section is created for easier search of systems configurability.
    </p>

    @foreach($templates as $file => $template)
        <div class="card mb-4">
            <div class="card-header">
                <h4 class="mb-0">{{ $file }}</h4>
            </div>
            <div class="card-body">
                <pre>{!! trim($template, "\n ") !!}</pre>
            </div>
        </div>
    @endforeach

@endsection
