<?php

use Illuminate\Routing\Router;
use Mtc\Core\Http\Controllers\Auth\LoginController;
use Mtc\Core\Http\Controllers\Auth\ForgotPasswordController;
use Mtc\Core\Http\Controllers\Auth\ResetPasswordController;
use \Mtc\Core\Http\Controllers\Admin\ConfigController;

/** @var Router $router */
$router->group([
    'namespace' => '\\',
    'prefix' => '/admin/',
    'middleware' => [
        'guest'
    ]
], function (Router $router) {

    $router->get('login', [LoginController::class, 'showLoginForm'])->name('admin.login');
    $router->post('login', [LoginController::class, 'login']);
    $router->get('forgot-password', [ForgotPasswordController::class, 'show'])->name('password.request');
    $router->post('forgot-password', [ForgotPasswordController::class, 'send'])->name('password.send_reset');
    $router->get('reset-password', [ResetPasswordController::class, 'show'])->name('password.show_reset');
    $router->post('reset-password', [ResetPasswordController::class, 'reset'])->name('password.reset');

});

/** @var Router $router */
$router->group([
    'namespace' => 'Mtc\Core\Http\Controllers',
    'prefix' => '/admin/',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    $router->get('/', 'Admin\AdminController@index')->name('admin.index');
    $router->get('logout', [LoginController::class, 'logout']);
    $router->get('/php-info', 'Admin\AdminController@phpInfo');

    $router->get('/stats', 'Admin\AdminController@stats')
        ->middleware([
            'permission:website-stats'
        ]);

    $router->get('/config', [ConfigController::class, 'index'])
        ->middleware([
            'role:mtc'
        ]);

    $router->group([
        'middleware' => 'permission:admin-menu'
    ], function (Router $router) {
        $router->patch('/menu', 'Admin\MenuController@reorder');
        $router->get('/menu/{menu_id}/delete', 'Admin\MenuController@destroy');
        $router->resource('/menu', 'Admin\MenuController');
    });

    $router->group([
        'middleware' => 'permission:component-manager'
    ], function (Router $router) {
        $router->get('/components', 'Admin\ComponentController@index');
        $router->post('/components', 'Admin\ComponentController@store');
    });

    $router->group([
        'middleware' => 'permission:seo-admin',
        'as' => 'seo.'
    ], function (Router $router) {
        $router->get('seo', 'Admin\SeoController@index');
        $router->post('seo', 'Admin\SeoController@post');
        $router->get('seo/help', 'Admin\SeoController@help');

        $router->get('seo/canonicals', 'Admin\SeoCanonicalController@index');
        $router->post('seo/canonicals', 'Admin\SeoCanonicalController@store');
        $router->put('seo/canonicals/{canonical}', 'Admin\SeoCanonicalController@update');
        $router->get('seo/canonicals/{canonical}/edit', 'Admin\SeoCanonicalController@edit');
        $router->get('seo/canonicals/{canonical}/del', 'Admin\SeoCanonicalController@destroy');

        $router->get('seo/defaults', 'Admin\SeoDefaultsController@index');
        $router->put('seo/defaults/{default}', 'Admin\SeoDefaultsController@update');
        $router->get('seo/defaults/{default}/edit', 'Admin\SeoDefaultsController@edit');

        $router->post('seo/csv/import', 'Admin\SeoCsvController@import');
        $router->post('seo/csv/export', 'Admin\SeoCsvController@export');

        $router->resource('seo/pages', 'Admin\SeoPageController');
        $router->resource('seo/brands', 'Admin\SeoBrandController');
        $router->resource('seo/categories', 'Admin\SeoCategoryController');
        $router->resource('seo/headings', 'Admin\SeoHeadingController');

        $router->get('seo/redirects', 'Admin\SeoRedirectController@index');
        $router->post('seo/redirects', 'Admin\SeoRedirectController@store');
        $router->put('seo/redirects/{redirect}', 'Admin\SeoRedirectController@update');
        $router->get('seo/redirects/{redirect}/edit', 'Admin\SeoRedirectController@edit');
        $router->get('seo/redirects/{redirect}/del', 'Admin\SeoRedirectController@destroy');
        $router->post('seo/redirects/import', 'Admin\SeoRedirectController@import');
        $router->post('seo/redirects/export', 'Admin\SeoRedirectController@export');
    });

    $router->group([
        'middleware' => 'permission:admin-users'
    ], function (Router $router) {
        $router->get('/users/{user_id}/login', 'Admin\AdminUsersController@login');
        $router->resource('/users', 'Admin\AdminUsersController');
        $router->resource('/roles', 'Admin\RoleController');
    });

    $router->get('/file-manager', 'Admin\FileManagerController@index')
        ->middleware([
            'permission:file-manager'
        ]);

    $router->get('/emails', 'Admin\EmailsController@index')
        ->middleware([
            'permission:core-emails'
        ]);

    $router->get('/populate', 'Admin\PopulateController@index')
        ->middleware([
            'permission:populate'
        ]);

    $router->post('/api/order', 'Admin\Api\OrderController@order');
    $router->post('/api/paginated_order', 'Admin\Api\OrderController@paginatedOrder');
});

$router->get('sitemap', [\Mtc\Core\Http\Controllers\SiteMapController::class, 'index']);
$router->post('address-finder', \Mtc\Core\Http\Controllers\AddressFinderController::class . '@search');
