<?php

namespace Mtc\Core\Seeds;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::query()
            ->create([
                'name' => 'mtc',
                'guard_name' => 'web',
                'group' => \Mtc\Core\Admin\Role::ADMIN_GROUP_NAME,
            ]);

        Role::query()
            ->create([
                'name' => 'Administrator',
                'guard_name' => 'web',
                'group' => \Mtc\Core\Admin\Role::ADMIN_GROUP_NAME,
            ]);

        $exists = \Mtc\Core\Admin\User::query()
            ->where('username', 'mtcadmin')
            ->exists();

        if (!$exists) {
            /** @var User $user */
            $user = \Mtc\Core\Admin\User::query()
                ->create([
                    'username' => 'mtcadmin',
                    'password' => '8803c59bbd004ce6f135e3212a8bd963c6a12962c6964f60cb83ef3ae04e7fc0',
                    'email' => 'mtc@mtcmedia.co.uk',
                    'name' => 'mtc.'
                ]);

            $user->assignRole('mtc');
        }

    }
}
