<?php

namespace Mtc\Core\Seo;

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * SEO Canonical URLs class
 *
 * Used for managing canonical URLs data for SEO.
 *
 * @package MTC\Core
 * @author Stephen McIntyre <stephen.mcintyre@mtcmedia.co.uk>
 */
class Canonical extends Eloquent
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'seo_canonicals';

    /**
     * No timestamps on model
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Mass assignable attributes
     * @var array
     */
    protected $fillable = [
        'path',
        'canonical_path'
    ];
}
