<?php

namespace Mtc\Core\Models;

use Illuminate\Database\Schema\Builder as SchemaBuilder;

/**
 * Template Interface for Migrations.
 *    Designed to maintain a contract for processes
 *
 * @package Mtc\Core\Models
 * @author   Kathryn Reeve <kathryn.reeve@mtcmedia.co.uk>
 * @copyright mtc. http://www.mtcmedia.co.uk/
 * @version   2016-09-30
 */
interface MigrationTemplate
{
    /**
     * This should return the pretty version of the class name.
     * This is used to display when migration is run, and stored in db
     *
     * @return string
     */
    public function getPrettyName();

    /**
     * This should return the full description of what the change does
     *
     * @return string
     */
    public function getDescription();

    /**
     * Perform the basic migration
     *   This function should return true on completion,
     *   false on failure.
     *
     * @param SchemaBuilder $schema
     *
     * @return bool
     */
    public function up(SchemaBuilder $schema);

    /**
     * This should implement the inverse of up
     *
     *
     * @param SchemaBuilder $schema
     *
     * @return bool
     */
    public function down(SchemaBuilder $schema);
}