<?php

namespace Mtc\Core\Seo;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Heading
 *
 * @package Mtc\Core\Seo
 */
class Heading extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'seo_headings';

    /**
     * Mass assignable variables
     *
     * @var array
     */
    protected $fillable = [
        'path',
        'text',
    ];

    /**
     * Query for export
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public static function exportQuery()
    {
        return self::query()
            ->select([
                'path',
                'text'
            ])
            ->orderBy('id');
    }
}
