<?php

namespace Mtc\Core\Images;

/*
 * Image Manipulation
 *
 * @package
 * @author Rihards Silins | Paul McAvoy
 * @copyright MTC Media 22/09/2014
 * @version 2
 * @access public
 *
 * Class that does various image file manipulations including recrop.
 */
class ImageManipulation
{
    /**
     * Generate new unique filename.
     *
     * @param string current_filename
     * @return string new_filename
     */
    public static function refreshImageUniqueName($current_filename)
    {
        // get original filename by removing the prepend time()
        preg_match("/^[0-9]{10}(.+\.[^\.]+)$/", $current_filename, $matches);
        // prepend a new time()
        $new_filename = time().$matches[1];

        return $new_filename;
    }

    /**
     * Raname cms2 image (all size cuts) to new name
     *
     * @param array $image_folders['']
     * @param string original_filename
     * @param string new_filename
     * @return bool success
     */
    public static function renameAllImageSizes($sizes, $original_filename, $new_filename)
    {
        if (empty($sizes)) {
            return false;
        }

        foreach ($sizes as $key => $size) {
            $directory_path = base_path('/' . $size['path'] . '/');

            if (is_dir($directory_path) && file_exists($directory_path.$original_filename)) {
                rename($directory_path.$original_filename, $directory_path.$new_filename);
            }
        }

        return true;
    }

    /**
     * Crop image according to params
     *
     * @param string image_filename
     * @param string source_path
     * @param array cms_images_target_size_params
     * @param string jcrop_width
     * @param string jcrop_height
     * @param string jcrop_x_offset
     * @param string jcrop_y_offset
     * @return bool success
     */
    public static function recrop($filename, $source_path, $size_params, $jcrop_width, $jcrop_height, $jcrop_x_offset, $jcrop_y_offset)
    {
        $original_image_path = base_path('/' . $source_path . '/' . $filename);

        $result = copy(
            $original_image_path,
            base_path('/' . $size_params['path'] . '/' . $filename)
        );

        if ($result === false) {
            return false;
        }

        ImageOptimise::optimiseImage($original_image_path, 80);

        self::imageCrop(
            $size_params['path'], //source
            $filename, //dest
            $jcrop_width,
            $jcrop_height,
            $jcrop_x_offset,
            $jcrop_y_offset
        );

        self::theImageResize(
            $size_params['width'],
            $size_params['height'],
            $size_params['path'], //source
            $filename //dest
        );

        return true;
    }

    /**
     * theImageResize()
     *
     * Uses imageMagick to resize image
     *
     * @param mixed $width
     * @param mixed $height
     * @param mixed $folder
     * @param mixed $pic
     * @param bool  $forced_width
     * @param bool  $forced_height
     * @return
     */
    public static function theImageResize($width, $height, $folder, $pic, $forced_width = false, $forced_height = false)
    {
        if ($forced_width === true) {
            $width = '!' . $width;
        }
        if ($forced_height === true) {
            $height = '!' . $height;
        }
        $command = IMAGE_MOGRIFY . " -resize ${width}x${height} '" . base_path("/" . $folder . "/" . $pic) . "'";
        exec($command, $result);
    }

    /**
     * imageCrop()
     *
     * Uses imageMagick to crop image from the top left
     *
     * @param mixed $folder
     * @param mixed $pic
     * @param mixed $width
     * @param mixed $height
     * @param mixed $x
     * @param mixed $y
     * @return
     */
    public static function imageCrop($folder, $pic, $width, $height, $x, $y)
    {
        $width = intval($width);
        $height = intval($height);
        $x = intval($x);
        $y = intval($y);
        $command = IMAGE_MOGRIFY . " -crop ${width}x${height}+${x}+${y} +repage '" . base_path('/' . $folder . '/' . $pic) . "'";
        shell_exec($command);
    }

    /**
     * imageCropCentercrop()
     *
     * Uses imageMagick to crop image from the center
     *
     * @param mixed $folder
     * @param mixed $pic
     * @param mixed $width
     * @param mixed $height
     * @param mixed $x
     * @param mixed $y
     * @return
     */
    public static function imageCropCentercrop($folder, $pic, $width, $height, $x, $y)
    {
        $command = IMAGE_MOGRIFY . " -resize '${width}x${height}^' -gravity center -crop ${width}x${height}+${x}+${y} +repage " . base_path('/' . $folder . '/' . $pic);
        shell_exec($command);
    }

    /**
     * imageCmykToRgb()
     *
     * Uses imageMagick to change the colour profile of the image
     *
     * @param mixed $folder
     * @param mixed $pic
     * @return
     */
    public static function imageCmykToRgb($folder, $pic)
    {
        $command = IMAGE_MOGRIFY . ' -colorspace RGB ' . base_path('/' . $folder . '/' . $pic);
        $details = shell_exec($command);
    }
}
