<?php

namespace Mtc\Core\Http\Controllers;

use CategoryHelper;
use App\Http\Controllers\Controller;
use Mtc\Shop\Brand;

/**
 * Class SitemapController
 *
 * @package App\Http\Controllers
 */
class SiteMapController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        if (defined('CMS_ENABLED') && CMS_ENABLED === true) {

            $site_map_data['cms_tree'] = \CMSNav::tree(
                0,
                PHP_INT_MAX,
                [
                    'check_innav' => false, // we want all the pages
                    'check_searchable' => true
                ]
            );

        }

        if (defined('SHOP_ENABLED') && SHOP_ENABLED === true) {

            // Get the category tree
            $site_map_data['category_tree'] = CategoryHelper::getCategoryTree();

            // Get the brands tree if brands are enabled
            if (defined('BRANDS_ENABLED') && BRANDS_ENABLED === true) {
                $site_map_data['brand_tree'] = Brand::getAllBrands();
            }

        }

        $options = [
            'site_map_data' => $site_map_data,
            'page_meta' => [
                'title' => 'Site map',
                'page_title' => 'Site map',
                'page_sub_title' => 'Every page on the site',
                'layout' => 'default.twig',
            ],
        ];

        return template('pages/sitemap.twig', $options);
    }
}
