<?php

namespace Mtc\Core\Seo;

use Mtc\Shop\Brand;

/**
 * Seo brands class
 *
 * @author: Lukas Giegerich | mtc.
 * @version 2014-01-20
 * @deprecated
 */
class SeoBrands
{
    /**
     * gets array of seo data for all brands from db
     *
     * @param int $id
     * @return array
     */
    public function getBrand($id)
    {
        $brand = Brand::query()
            ->select([
                'id',
                'name',
                'seo_title as title',
                'seo_description as description'
            ])
            ->find($id);

        if ($brand) {
            return $brand->toArray();
        }

        return [
            'id' => '',
            'name' => '',
            'title' => '',
            'description' => '',
        ];
    }

    /**
     * updates brand seo data in db
     *
     * @param int $id
     * @param string $title
     * @param string $description
     */
    public function updateBrand($id, $title, $description)
    {
        Brand::query()
            ->where('id', $id)
            ->update([
                'seo_title' => $title,
                'seo_description' => $description
            ]);
    }

    /**
     * sets seo data for given brand to empty string
     * @param int $id
     */
    public function deleteBrand($id)
    {
        $this->updateBrand($id, '', '');
    }

}
