<?php

namespace Mtc\Core\Keywords;

use Illuminate\Database\Eloquent\Model;

/*
 * Keyword Class - Eloquent model.
 * Can be any kind of keyword or tag.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 *
 */
class Keyword extends Model
{
    /**
     * Load Keyword model from keyword string
     *
     * @param string $keyword
     * @return static
     */
    public static function fromKeyword($keyword)
    {
        return static::where("keyword", $keyword)->firstOrFail();
    }

    protected $fillable = ['keyword'];

    public $timestamps = false;

    /**
     * Create a new Eloquent Collection instance.
     *
     * @param  array $models
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function newCollection(array $models = array())
    {
        return new KeywordCollection($models);
    }
}
