<?php

namespace Mtc\Core\Admin;

/**
 * Class Permission
 * Admin user Permission model
 * Adds global scope that narrows roles down to admin only
 *
 * @package Mtc\Core\Admin
 */
class Permission extends \Spatie\Permission\Models\Permission
{
    /**
     * Name of the role group for admin users
     */
    const ADMIN_GROUP_NAME = 'admin';

    /**
     * Extend model booting
     */
    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            return $query->where('model_group', self::ADMIN_GROUP_NAME);
        });

        self::creating(function ($role) {
            $role->model_group = self::ADMIN_GROUP_NAME;
        });
    }
}