<?php

namespace Mtc\Core\Seo;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Seo Setting
 *
 * @package Mtc\Core\Seo
 */
class Setting extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'seo_settings';

    /**
     * Mass assignable variables
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'description'
    ];

    /**
     * Gets the value of an seo setting based on a given key.
     *
     * @param string $key
     * @return string
     */
    public static function getSettingValue($key)
    {
        return static::query()->where('key', $key)->first()->value ?? '';
    }
}
