# Core Shop Analytics Stats

This package works as a patch for sites that require google analytics 
in dashboard stats as legacy version is broken as of Dec 2020.

This integration relies on using Google Reporting API v4 which is the main 
supported integration during the creation of the package.

# Installation & Setup

1. Install package
```
composer require mtcmedia/core-analytics-stats
```

2. Marketing needs to add `analytics-api@analytics-api-199513.iam.gserviceaccount.com`
to the website data view and provide the view ID for the site. 


3. Use the view ID in code when calling stats and update the first 4 entries 
for the Visitor stats by replacing local function calls with $calls on $analytics object.
Note that the basket visitor count method is called differently than previously 

```php
$analytics = (new \Mtc\AnalyticsStats\Stats('INSERT_VIEW_ID'));
$dashboardData[0]['Number of Visits'] = $numVisits = $analytics->getTotalVisits(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']));
$dashboardData[0]['Number of Unique Visitors'] = $uniqueVisitors = $analytics->getTotalVisitors(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']));
$dashboardData[0]['Conversion Rate %'] = $conversionRate = $analytics->getConversionRate(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']));
$dashboardData[0]['Visitors to Basket Page'] = $visitorsBasket = $analytics->getTotalVisitorsToPage(date_dmy_to_db($_REQUEST['start-date']), date_dmy_to_db($_REQUEST['end-date']), '/shop/checkout/basket.php');
```