<?php

namespace Mtc\ContentManager\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Mtc\ContentManager\Models\Page;

class PageSlugDoesNotConflict implements ValidationRule
{
    public function __construct(private readonly ?int $pageId = null, private readonly ?int $parentId = null)
    {
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $exists = Page::query()
            ->when($this->pageId, fn($query) => $query->where('id', '!=', $this->pageId))
            ->where('parent_id', $this->parentId ?: null)
            ->where('page_slug', $value)
            ->exists();

        if ($exists) {
            $fail(__('content::validation_attributes.slug_taken'));
        }
    }
}
