<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse;

class RemoveMediaUseOutdatedSizes implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected readonly array $mediaSize)
    {
        $this->onQueue('media');
    }

    public function handle()
    {
        MediaUse::query()
            ->where('owner_type', $this->mediaSize['model'])
            ->chunk(100, fn(Collection $chunk) => $chunk->each(fn(MediaUse $use) => Media::removeMediaUseSize(
                $use,
                $this->mediaSize['width'],
                $this->mediaSize['height']
            )));
    }
}
