<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\Media;
use Mtc\ContentManager\Contracts\MediaUse;

class MediaResizeRequest extends FormRequest
{
    /**
     * @var MediaUse|null
     */
    protected $media_model;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'size' => [
                'required',
                'regex:/[0-9]+x[0-9]+/',
            ],
            'media_use_id' => 'required',
            'coordinates' => [
                'required',
                'array'
            ],
            'coordinates.*' => 'numeric',
            'coordinates.0' => 'min:0',
            'coordinates.1' => 'min:0',
            'coordinates.2' => 'gt:coordinates.0',
            'coordinates.3' => 'gt:coordinates.1'
        ];
    }

    /**
     * @return Media
     */
    public function media(): MediaUse
    {
        if ($this->media_model) {
            return $this->media_model;
        }

        return $this->media_model = App::make(MediaUse::class)
            ->newQuery()
            ->findOrFail($this->input('media_use_id'));
    }

    public function width()
    {
        return $this->dimensions()[0];
    }

    public function height()
    {
        return  $this->dimensions()[1];
    }

    public function dimensions()
    {
        return explode('x', $this->input('size'));
    }
}
