<?php

namespace Mtc\ContentManager\Filters;

use Intervention\Image\Filters\FilterInterface;
use Intervention\Image\Image;

readonly class FocalCropFilter implements FilterInterface
{
    public function __construct(
        private int $width,
        private int $height,
        private int $focalX,
        private int $focalY,
        private bool $resize = true
    ) {
        //
    }

    public function applyFilter(Image $image): Image
    {
        return $this->resize
            ? $this->withResize($image)
            : $this->onlyCrop($image);
    }

    private function withResize(Image $image): Image
    {
        $resizeWidth = $image->width();
        $resizeHeight = $image->height();
        $aspect = $resizeWidth / $resizeHeight;

        if ($resizeWidth / $this->width > $resizeHeight / $this->height) {
            // width scaling is bigger than height scaling, use height for calculating end width
            $resizeWidth = $this->height * $aspect;
            $resizeHeight = $this->height;
        } else {
            $resizeWidth = $this->width;
            $resizeHeight = $this->width / $aspect;
        }

        $cropX = max(0, ($this->focalX / 100) * $resizeWidth - ($this->width / 2));
        $cropY = max(0, ($this->focalY / 100) * $resizeHeight - ($this->height / 2));

        $cropX = min($cropX, $resizeWidth - $this->width);
        $cropY = min($cropY, $resizeHeight - $this->height);
            return $image->resize($resizeWidth, $resizeHeight)
                ->crop($this->width, $this->height, (int) $cropX, (int) $cropY);
    }

    private function onlyCrop(Image $image): Image
    {
        $originalWidth = $image->width();
        $originalHeight = $image->height();

        $cropX = max(0, ($this->focalX / 100) * $originalWidth - ($this->width / 2));
        $cropY = max(0, ($this->focalY / 100) * $originalHeight - ($this->height / 2));

        $cropX = min($cropX, $originalWidth - $this->width);
        $cropY = min($cropY, $originalHeight - $this->height);

        return $image->crop($this->width, $this->height, (int)$cropX, (int)$cropY);
    }
}
