<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\FormField;

class Group extends FormField
{
    public const NAME = 'Group';
    public const ICON = 'layer-group';
    public const COMPONENT = 'Group';

    public function toArray()
    {
        return [
            'icon' => self::ICON,
            'name' => self::NAME,
            'description' => 'Group elements together',
            'component' => self::COMPONENT,
            'type' => 'group',
            'nestable' => true,
            'nestedLimit' => 5,
            'editable' => true,
            'repeatable' => true,
            'isGroup' => true,
        ];
    }
}
