<?php

namespace Mtc\ContentManager;

use Exception;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\FormField;

class FieldRepository
{
    public function field(string $name): FormField
    {
        $fieldClass = config("pages.field_types.$name");
        if (empty($fieldClass)) {
            throw new Exception("Unsupported field type: $name");
        }

        return App::make($fieldClass);
    }

    public function __call(string $name, array $arguments)
    {
        return $this->field($name);
    }
}
