<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Kalnoy\Nestedset\NodeTrait;
use Mtc\ContentManager\Factories\MediaFactory;
use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Traits\ModelSortAndFilter;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

abstract class MediaFolder extends Model
{
    use NodeTrait;
    use HasFactory;
    use ModelSortAndFilter;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'order',
        'slug',
    ];

    /**
     * Hide attributes from json
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function media(): HasMany
    {
        return $this->hasMany(config('media.media_model'), 'folder_id');
    }
}
