<?php

namespace Mtc\ContentManager\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\PageModel;

class DeleteOldTrashedPages extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pages:clean-trashed-pages';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete trash pages that have expired';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(protected PageModel $page)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        $delay = Config::get('pages.trashed_pages_deleted_after_days');
        $this->page->newQuery()
            ->onlyTrashed()
            ->where('deleted_at', '<=', Carbon::now()->subDays($delay))
            ->get()
            ->each(function (PageModel $page) {
                $page->forceDelete();
            });
        return 0;
    }
}
