<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('page_template_elements', function (Blueprint $table) {
            $table->string('field_type')->nullable()->after('global_content_id');
            $table->text('data')->nullable()->after('hint');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('page_template_elements', function (Blueprint $table) {
            $table->dropColumn([
                'field_type',
                'data',
            ]);
        });
    }
};
