<?php

namespace Mtc\ContentManager\Tests\Unit;

use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Tests\TestCase;

class MediaSizeModelTest extends TestCase
{
    public function testDimensionsAttribute(): void
    {
        /** @var MediaSize $model */
        $model = app(MediaSize::class);
        $model->width = 100;
        $model->height = 200;

        self::assertEquals('100x200', $model->dimensions);
        self::assertEquals('100x200', $model->getDimensionsAttribute());
    }

    public function testNameAttributeWithLabel(): void
    {
        /** @var MediaSize $model */
        $model = app(MediaSize::class);
        $model->width = 100;
        $model->height = 200;
        $model->label = 'Something';

        self::assertStringContainsString('100x200', $model->name);
        self::assertStringContainsString('Something', $model->name);
        self::assertEquals('100x200 (Something)', $model->name);

        self::assertStringContainsString('100x200', $model->getNameAttribute());
        self::assertStringContainsString('Something', $model->getNameAttribute());
        self::assertEquals('100x200 (Something)', $model->getNameAttribute());
    }

    public function testNameAttributeWithoutLabel(): void
    {
        /** @var MediaSize $model */
        $model = app(MediaSize::class);
        $model->width = 100;
        $model->height = 200;

        self::assertEquals('100x200', $model->name);
        self::assertEquals('100x200', $model->getNameAttribute());
    }

    public function testSizeUrlPath(): void
    {
        /** @var MediaSize $model */
        $model = app(MediaSize::class);
        $model->width = 100;
        $model->height = 200;

        $this->assertStringContainsString('100x200', $model->size_url_path);
    }
}
