<?php

namespace Mtc\ContentManager\Tests\Feature;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Queue;
use Mtc\ContentManager\Http\Resources\PageViewResource;
use Mtc\ContentManager\Jobs\GenerateSizeForMediaFileJob;
use Mtc\ContentManager\Models\Content;
use Mtc\ContentManager\Models\MediaUse;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Version;
use Mtc\ContentManager\Models\VersionContent;
use Mtc\ContentManager\PageRepository;
use Mtc\ContentManager\Tests\TestCase;

class VersionTest extends TestCase
{
    use RefreshDatabase;

    public function testCreateVersionCopiesContent()
    {
        $this->seedScenario(__FUNCTION__);
        Queue::fake();
        /** @var PageRepository $repository */
        $repository = App::make(PageRepository::class);

        $page = Page::query()->where('slug', 'home')->first();
        $resource = json_decode((new PageViewResource($page))->toResponse(request())->content(), true);
        $content = $resource['page']['content'];

        $this->assertFalse(Version::query()->where('page_id', $page->id)->where('author_id', 1)->exists());

        $version = $repository->savePageVersion($page, $content, 1);

        Queue::assertNotPushed(GenerateSizeForMediaFileJob::class);
        $this->assertTrue(Version::query()->where('page_id', $page->id)->where('author_id', 1)->exists());
        $this->assertEquals(
            MediaUse::query()->where('owner_type', 'content')->count(),
            MediaUse::query()->where('owner_type', 'version_content')->count(),
        );
        $this->assertEquals(
            Content::query()->where('page_id', $page->id)->count(),
            VersionContent::query()->where('owner_id', $version->id)->count(),
        );
    }

    public function testSyncWithTemplateCreatesVersion()
    {
        $this->seedScenario(__FUNCTION__);

        /** @var PageRepository $repository */
        $repository = App::make(PageRepository::class);
        $page = Page::query()->where('slug', 'home')->first();
        $this->assertFalse(Version::query()->where('page_id', $page->id)->where('author_id', 1)->exists());

        $repository->syncContentWithTemplate($page->id, $repository->hasVersioning());

        $this->assertTrue(Version::query()->where('page_id', $page->id)->where('author_id', 1)->exists());
    }
}
