<?php

namespace Mtc\ContentManager\Observers;

use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\GlobalContent;
use Mtc\ContentManager\Traits\EnsuresSlug;

class GlobalContentObserver
{
    use EnsuresSlug;

    public function creating(GlobalContent $globalContent)
    {
        $globalContent->slug = $this->ensureSlug($globalContent->name, $globalContent);
    }

    /**
     * Things to do when Global content was created
     *
     * @param GlobalContent $globalContent
     */
    public function created(GlobalContent $globalContent)
    {
        $this->attachUser($globalContent, Auth::id());
    }

    /**
     * Add user to Global content managers
     * Accepting null for automated creation via cli/jobs
     *
     * @param GlobalContent $globalContent
     * @param int|null $user_id
     */
    protected function attachUser(GlobalContent $globalContent, ?int $user_id)
    {
        if ($user_id) {
            $globalContent->users()->attach($user_id);
        }
    }
}
