<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\ImageSize;

class GenerateSizeForMediaFileJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected MediaModel $media, public readonly ImageSize $size)
    {
        $this->onQueue('media');
    }

    public function handle()
    {
        Media::createSize($this->media, $this->size);
    }
}
