<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GlobalContentElementView extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load('mediaUses.media');
        $this->resource->content = $this->resource->contentElement?->fields
            ->map(fn($field) => $this->mapField($field, $this->resource->content[0]['children'] ?? []));

        $this->resource->setVisible([
            'id',
            'fields',
            'slug',
            'name',
            'ui_component',
            'element_id',
            'content',
            'type',
        ]);
        return parent::toArray($request);
    }

    protected function mapField($field, $content)
    {
        $field->content = $this->getAttributeFormContent($field, $content, 'content');
        $field->icon = $this->getIcon($field->field_type);
        $field->component = $this->getComponent($field->field_type);
        $field->children = $field->child_element_id
            ? $field->childElement?->fields->map(
                fn($field) => $this->mapField(
                    $field,
                    $this->getAttributeFormContent($field, $content, 'children')
                )
            )
            : [];
        return $field;
    }

    protected function getIcon(string $type): string
    {
        return match ($type) {
            'email' => 'at',
            'number' => 'hashtag',
            'date' => 'calendar-days',
            'textarea' => 'font-case',
            'file' => 'file',
            'image' => 'image',
            'location' => 'location-dot',
            'select' => 'list-dropdown',
            'boolean' => 'square-check',
            'checkbox' => 'square',
            'offer_id' => 'badge-dollar',
            'page_id' => 'file-lines',
            'vehicle_id' => 'car',
            default => 'text',
        };
    }

    protected function getComponent(string $type): string
    {
        return match ($type) {
            'text' => 'EditableContentTextField',
            'image' => 'EditableContentImageUpload',
            'editor' => 'EditableContentEditor',
            default => '',
        };
    }

    protected function getAttributeFormContent($field, $fromContent, string $attribute = 'content')
    {
        $value = collect($fromContent)
            ->filter(fn($value) => ($value['id'] ?? '') === $field->id)
            ->first();

        if ($value && $attribute === 'content' && $field->field_type === 'image') {
            return collect($value[$attribute])->pluck('id')->toArray();
        }

        return $value[$attribute] ?? null;
    }
}
