<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Rules\PageContentHasAllBlueprintFields;

class UpdateVersionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'content' => [
                'array',
            ],
            'content.*.id' => [
                'present',
            ],
            'content.*.element_id' => [
                'nullable',
                'numeric',
                'exists:content_elements,id'
            ],
            'content.*.global_content_id' => [
                'nullable',
                'numeric',
                'exists:global_content,id'
            ],
            'content.*.content' => [
                'nullable',
            ],
            'content.*' => [
                'array',
                new PageContentHasAllBlueprintFields(),
            ],
        ];
    }
}
