<?php

namespace Mtc\ContentManager\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Http\Requests\RemoveContentTagRequest;
use Mtc\ContentManager\Http\Requests\StoreContentTagRequest;
use Mtc\ContentManager\Http\Requests\UpdateContentTagRequest;
use Mtc\ContentManager\Models\ContentTag;

class ContentTagController
{
    use ValidatesRequests;

    public function index(Request $request, ContentTag $tag)
    {
        $resourceClass = Config::get('pages.tag_list_resource');
        return new $resourceClass($tag
            ->newQuery()
            ->setSortBy($request->input('sort_by'))
            ->setFilters($request->input('filters') ?? '')
            ->paginate());
    }

    public function store(StoreContentTagRequest $request, ContentTag $tag)
    {
        return $tag->newQuery()
            ->create($request->input());
    }

    public function show(Request $request, ContentTag $tag)
    {
        $resourceClass = Config::get('pages.tag_view_resource');
        return  new $resourceClass($tag);
    }

    public function update(UpdateContentTagRequest $request, ContentTag $tag)
    {
        $tag->update($request->input());
        $tag->refresh();

        return [
            'tag' => $tag,
            'success' => true,
        ];
    }

    public function destroy(RemoveContentTagRequest $request, ContentTag $model, int $id)
    {
        $model->newQuery()->find($id)?->delete();
    }
}
