<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;
use Mtc\ContentManager\Models\MediaSize;

class Image extends FormField
{
    public const ICON = 'image';
    public const NAME = 'Images';
    public const DESCRIPTION = 'Field to upload images';
    public const COMPONENT = 'ImageUpload';
    public const TYPE = 'image';
    public const FIELD_ID = 'image';

    public function toArray()
    {
        return array_merge(parent::toArray(), [
            'mediaSizeOptions' => MediaSize::query()
                ->orderBy('label')
                ->get()
                ->map(fn($mediaSize) => [
                    'id' => $mediaSize->dimensions,
                    'name' => $mediaSize->name,
                ])
                ->unique('id')
                ->values()
        ]);
    }
}
