<?php

namespace Mtc\ContentManager\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\Comment;

class CommentFactory extends Factory
{
    protected $model = Comment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'commentable_type' => $this->faker->word(),
            'commentable_id' => random_int(1, 100),
            'parent_id' => random_int(0, 1) ? random_int(1, 10) : null,
            'author_id' => random_int(1, 10),
            'content' => $this->faker->paragraph(),
            'resolved_at' => random_int(0, 1) ? Carbon::now()->subMinutes(random_int(1, 10000)) : null,
        ];
    }
}
