<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;
use Mtc\ContentManager\Models\MediaSize;

class Image extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.image');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'multiple' => [
                'type' => 'checkbox',
                'name' => 'Multiple?',
            ],
            'allowed_sizes' => [
                'type' => 'select',
                'name' => 'Allowed Sizes',
                'multiple' => true,
                'validation' => 'required',
                'values' => $this->imageSizes(),
            ],
            'min_value' => [
                'type' => 'image-dimensions',
                'name' => 'Minimum',
                'value' => [
                    'width' => 300,
                    'height' => 300,
                ],
                'instructions' => 'Restrict which images can be uploaded',
            ],
            'max_value' => [
                'type' => 'text',
                'append' => 'MB',
                'value' => 10,
                'name' => 'Maximum File Size',
                'instructions' => 'Restrict which images can be uploaded',
            ],
            'allowed_file_types' => [
                'type' => 'select',
                'multiple' => true,
                'name' => 'Allowed File Types',
                'values' => config('media.media_types.images'),
                'value' => [
                    'jpg',
                    'png'
                ]
            ],
        ];
    }

    public function getValue($value)
    {
        return $value->field->data['multiple'] ? $value->media : $value->media->first();
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }

    protected function imageSizes(): array
    {
        return MediaSize::all()
            ->map(function ($size) {
                return [
                    'key' => $size->dimensions,
                    'name' => $size->name,
                ];
            })->pluck('name', 'key')
            ->toArray();
    }
}
