<?php

use Illuminate\Routing\Router;
use Mtc\ContentManager\Http\Controllers\CommentController;
use Mtc\ContentManager\Http\Controllers\ElementController;
use Mtc\ContentManager\Http\Controllers\GlobalElementController;
use Mtc\ContentManager\Http\Controllers\MenuController;
use Mtc\ContentManager\Http\Controllers\PageController;
use Mtc\ContentManager\Http\Controllers\TemplateController;
use Mtc\ContentManager\Http\Controllers\MediaController;
use Mtc\ContentManager\Http\Controllers\MediaLibraryController;
use Mtc\ContentManager\Http\Controllers\MediaSizeController;
use Spatie\LaravelImageOptimizer\Middlewares\OptimizeImages;

/** @var Router $router */

$router->group([
    'prefix' => 'content',
    'as' => 'content.'
], function (Router $router) {
    // Content Pages
    $router->post('/pages/{page}/restore-version/{version}', [PageController::class, 'restoreVersion'])
        ->name('pages.restore-version');
    $router->post('/pages/{page}/copy', [PageController::class, 'copy'])->name('pages.copy');
    $router->post('/pages/{page}/restore', [PageController::class, 'restore'])->name('pages.restore');
    $router->post('/pages/{page}/check-slug', [PageController::class, 'checkSlug'])->name('pages.check-slug');
    $router->post('/pages/empty-trash', [PageController::class, 'emptyTrash'])->name('pages.empty-trash');
    $router->apiResource('/pages', PageController::class);

    // Comments
    $router->post('/comments', [CommentController::class, 'store'])->name('comments.store');
    $router->post('/comments/{comment}/mark-resolved', [CommentController::class, 'markResolved'])
        ->name('comments.mark-resolved');

    // Menus
    $router->apiResource('/menus', MenuController::class);

    // Content Elements
    $router->post('elements/{element}/copy', [ElementController::class, 'copy'])->name('elements.copy');
    $router->get('elements/{element}/usage', [ElementController::class, 'checkUsage'])->name('elements.show-usage');
    $router->get('elements/{element}/usage/{type}', [ElementController::class, 'fullUsageList'])
        ->name('elements.show-usage-for-type');
    $router->get('elements/icons', [ElementController::class, 'icons'])->name('elements.icons');
    $router->apiResource('elements', ElementController::class);

    // Global content elements
    $router->post('global-elements/{element}/copy', [GlobalElementController::class, 'copy'])->name('global-elements.copy');
    $router->apiResource('global-elements', GlobalElementController::class);

    // Content Templates
    $router->post('templates/{template}/copy', [TemplateController::class, 'copy'])->name('templates.copy');
    $router->get('templates/unused', [TemplateController::class, 'unused'])->name('templates.unused');
    $router->apiResource('templates', TemplateController::class);

    // Media File actions
    $router->post('media/resize', [MediaController::class, 'resize'])->name('media.resize');
    $router->post('media', [MediaController::class, 'store'])->middleware(OptimizeImages::class)->name('media.store');
    $router->apiResource('media', MediaController::class)->except(['store']);

    // Media file sizes
    $router->post('media-sizes/for-dimensions', [MediaSizeController::class, 'forDimensions'])
        ->name('media-sizes.for-dimensions');
    $router->resource('media-sizes', MediaSizeController::class)->only(['index', 'store', 'destroy']);

    // Media library
    $router->get('media-library', [MediaLibraryController::class, 'index'])->name('media-library.index');
    $router->delete('media-library/bulk-delete', [MediaLibraryController::class, 'bulkDelete'])->name('media-library.bulk-delete');
    $router->get('media-library/show', [MediaLibraryController::class, 'show'])->name('media-library.show');
    $router->get('media-library/{media}/show-uses', [MediaLibraryController::class, 'showUses'])
        ->name('media-library.show-uses');
});
