<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Text extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.text');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'default_value' => [
                'type' => 'text',
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'placeholder' => [
                'type' => 'text',
                'name' => __('content::fields.placeholder'),
                'instructions' => 'Appears within the input',
            ],
            'prepend' => [
                'type' => 'text',
                'name' => __('content::fields.prepend'),
                'instructions' => 'Appears before the input',
            ],
            'append' => [
                'type' => 'text',
                'name' => __('content::fields.append'),
                'instructions' => 'Appears after the input',
            ],
            'character_limit' => [
                'type' => 'text',
                'name' => __('content::fields.character_limit'),
                'instructions' => 'Leave blank for no limit',
            ],
        ];
    }


    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
            ($field->data['character_limit'] ?? 0) > 0 ? 'max:' . $field->data['character_limit'] : '',
        ];
    }
}
