<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('media', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->string('src');
            $table->string('path');
            $table->string('alt_text')->nullable();
            $table->string('title')->nullable();
            $table->string('caption')->nullable();
            $table->string('description')->nullable();
            $table->string('upload_date', 7)->index();
            $table->timestamps();
        });

        Schema::create('media_uses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('media_id')->index();
            $table->morphs('owner');
            $table->string('alt_text')->nullable();
            $table->string('title')->nullable();
            $table->string('caption')->nullable();
            $table->string('description')->nullable();
            $table->string('dimensions')->nullable();
            $table->text('data')->nullable();
            $table->text('allowed_sizes')->nullable();
            $table->boolean('primary')->nullable()->index();
            $table->boolean('secondary')->nullable()->index();
            $table->text('flags')->nullable();
            $table->unsignedInteger('order')->default(0);
            $table->timestamps();

            $table->unique([
                'media_id',
                'owner_id',
                'owner_type',
            ]);
        });

        Schema::create('media_sizes', function (Blueprint $table) {
            $table->id();
            $table->smallInteger('width')->nullable();
            $table->smallInteger('height')->nullable();
            $table->string('label')->nullable();
            $table->timestamps();
        });

        Schema::create('media_tags', function (Blueprint $table) {
            $table->id();
            $table->foreignId('media_id')->index();
            $table->foreignId('tag')->index();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('media');
        Schema::dropIfExists('media_uses');
        Schema::dropIfExists('media_sizes');
        Schema::dropIfExists('media_tags');
    }
}
