<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Mtc\ContentManager\PageStatus;
use Mtc\ContentManager\Rules\IsSlugRule;
use Mtc\ContentManager\Rules\PageContentHasAllBlueprintFields;

class UpdateTemplateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'description' => 'present',
            'seo_defaults' => 'array',
            'meta' => 'array',
            'elements' => [
                'array',
            ],
            'elements.*.id' => [
                'nullable',
                'numeric',
            ],
            'elements.*.element_id' => [
                'present',
                'nullable',
                'numeric',
                'exists:content_elements,id'
            ],
            'elements.*.global_content_id' => [
                'present',
                'nullable',
                'numeric',
                'exists:global_content,id'
            ],
            'elements.*.name' => [
                'nullable',
            ],
        ];
    }
}
